<?php

/*
    Created by Mohamed.
*/

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CountryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        $locale = request()->header('Accept-Language', 'ar');

        return [
            'id' => $this->id,
            'name' => $this->name[$locale] ?? '',
            // 'governorates' => GovernorateResource::collection($this->governorates),
        ];
    }
}