<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API;

use App\Models\Subscription;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class SubscriptionController extends Controller
{
    public function store(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|unique:subscriptions,email',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
            ], 422);
        }

        // Get IP address (considering proxies)
        $ipAddress = $request->ip();

        // Fetch location data from IP
        try {
            $response = Http::get('http://ip-api.com/json/' . $ipAddress);
            $locationData = $response->json();

            if ($locationData['status'] === 'fail') {
                throw new \Exception('Failed to fetch location data');
            }

            // Create subscription
            $subscription = Subscription::create([
                'email' => $request->email,
                'ip_address' => $ipAddress,
                'country' => $locationData['country'] ?? null,
                'city' => $locationData['city'] ?? null,
            ]);

            return response()->json([
                'message' => 'Subscription created successfully',
                'subscription' => $subscription,
            ], 201);

        } catch (\Exception $e) {
            $subscription = Subscription::create([
                'email' => $request->email,
                'ip_address' => $ipAddress,
                'country' => null,
                'city' => null,
            ]);

            return response()->json([
                'message' => 'Subscription created, but failed to fetch location data',
                'subscription' => $subscription,
            ], 201);
        }
    }
}