<?php

/*
    Created by Mohamed.
*/

namespace App\Http\Controllers\API;

use App\Models\Banner;
use App\Models\Slider;
use App\Models\Partner;
use App\Models\Product;
use App\Models\Discount;
use Illuminate\Http\Request;
use App\Models\Advertisement;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Resources\AdvertisementResource;
use App\Http\Resources\BannerResource;
use App\Http\Resources\SliderResource;
use App\Http\Resources\PartnerResource;
use App\Http\Resources\ProductResource;

class HomeController extends Controller
{
    /**
     * عرض المنتجات مع فلاتر الترتيب والبحث
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        try {
            // بناء استعلام المنتجات
            $productsQuery = Product::where('status_id', 1);

            if ($request->has('search') && !empty($request->query('search'))) {
                $productsQuery->where('name->ar', 'like', '%' . $request->query('search') . '%')
                    ->orWhere('name->en', 'like', '%' . $request->query('search') . '%');
            }

            // فلتر الترتيب
            if ($request->has('sort')) {
                switch ($request->query('sort')) {
                    case 'high_price':
                        $productsQuery->orderBy('price', 'desc');
                        break;
                    case 'low_price':
                        $productsQuery->orderBy('price', 'asc');
                        break;
                    case 'recent':
                        $productsQuery->orderBy('created_at', 'desc');
                        break;
                    default:
                        $productsQuery->orderBy('created_at', 'desc');
                        break;
                }
            } else {
                $productsQuery->orderBy('created_at', 'desc');
            }

            $products = $productsQuery->take(15)->get();

            $sliders = Slider::get();
            $partners = Partner::all();
            $banners = Product::where('appear_in_slider', 1)->where('status_id', 1)->get();
            $offers = Discount::where('place', 'home')->get();
            $advertisements_main = Advertisement::where('location_type', 'home')->where('key', 1)->get();
            $advertisements = Advertisement::where('location_type', 'home')->where('key', 0)->get();
            // $advertisements_offer = Discount::where('ads', 1)->get();
            $advertisements_offer = Discount::get();



            return response()->json([
                'message' => 'تم جلب البيانات بنجاح',
                //'products' => ProductResource::collection($products),
                'offers' => ProductResource::collection(
                    $offers->pluck('product')->filter()
                ),
                'sliders' => SliderResource::collection($sliders),
                'advertisements_offer' => ProductResource::collection($advertisements_offer->pluck('product')->filter()),
                'partners' => PartnerResource::collection($partners),
                'banners' => BannerResource::collection($banners),
                'advertisements_main' => AdvertisementResource::collection($advertisements_main),
                'advertisements' => AdvertisementResource::collection($advertisements),

            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'حدث خطأ',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}