<?php

/*
    Created by Mohamed.
*/

namespace App\Http\Controllers\API\Dashboard;

use App\Models\User;
use App\Models\Order;
use App\Models\Status;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;

class StatusController extends Controller
{
    /**
     * Get statuses with optional type filter
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request): JsonResponse
    {
        $request->validate([
            'type' => 'nullable|integer|in:1,2,3'
        ]);
        $query = Status::query();
        if ($request->has('type')) {
            $query->where('type', $request->input('type'));
        }
        $statuses = $query->select('id', 'name', 'type', 'color')->get();
        return response()->json([
            'success' => true,
            'data' => $statuses,
            'message' => 'Statuses retrieved successfully'
        ], 200);
    }
    public function update(Request $request, $id): JsonResponse
    {
        // Validate the request
        $request->validate([
            'type' => 'required|integer|in:1,2,3', // 1: product, 2: client (user), 3: order
            'status_id' => 'required|integer|exists:statuses,id'
        ]);

        // Verify status matches the type
        $status = Status::findOrFail($request->status_id);
        if ($status->type != $request->type) {
            return response()->json([
                'success' => false,
                'message' => 'Status type does not match the provided type'
            ], 422);
        }

        // Determine the model based on type
        $model = null;
        $modelName = '';
        switch ($request->type) {
            case 1: // Product
                $model = Product::find($id);
                $modelName = 'Product';
                break;
            case 2: // Client (User)
                $model = User::find($id);
                $modelName = 'User';
                break;
            case 3: // Order
                $model = Order::find($id);
                $modelName = 'Order';
                break;
        }

        if (!$model) {
            return response()->json([
                'success' => false,
                'message' => "$modelName not found"
            ], 404);
        }

        // Update the status
        $model->status_id = $request->status_id;
        $model->save();

        return response()->json([
            'success' => true,
            'data' => $model,
            'message' => "$modelName status updated successfully"
        ], 200);
    }
}