<?php

namespace App\Http\Controllers\API\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SettingController extends Controller
{
    /**
     * Retrieve social media links.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getSocialMedia()
    {
        $setting = Setting::first();

        if (!$setting) {
            return response()->json([
                'message' => 'لم يتم العثور على إعدادات',
            ], 404);
        }

        $socialMedia = [
            'facebook' => $setting->facebook,
            'instagram' => $setting->instagram,
            'x' => $setting->x,
            'linkedin' => $setting->linkedin,
            'discord' => $setting->discord,
            'youtube' => $setting->youtube,
            'pinterest' => $setting->pinterest,
            'whatsapp' => $setting->whatsapp,
        ];

        return response()->json([
            'message' => 'تم استرجاع روابط التواصل الاجتماعي بنجاح',
            'social_media' => $socialMedia,
        ], 200);
    }

    /**
     * Update social media links.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateSocialMedia(Request $request)
    {
        $setting = Setting::first();

        if (!$setting) {
            return response()->json([
                'message' => 'لم يتم العثور على إعدادات',
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'facebook' => 'nullable|url',
            'instagram' => 'nullable|url',
            'x' => 'nullable|url',
            'linkedin' => 'nullable|url',
            'discord' => 'nullable|url',
            'youtube' => 'nullable|url',
            'pinterest' => 'nullable|url',
            'whatsapp' => 'nullable|url',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'تأكد من صحة روابط التواصل الاجتماعي (يجب أن تكون URLs صالحة)',
                'errors' => $validator->errors(),
            ], 400);
        }

        $setting->update([
            'facebook' => $request->input('facebook', $setting->facebook),
            'instagram' => $request->input('instagram', $setting->instagram),
            'x' => $request->input('x', $setting->x),
            'linkedin' => $request->input('linkedin', $setting->linkedin),
            'discord' => $request->input('discord', $setting->discord),
            'youtube' => $request->input('youtube', $setting->youtube),
            'pinterest' => $request->input('pinterest', $setting->pinterest),
            'whatsapp' => $request->input('whatsapp', $setting->whatsapp),
        ]);

        $socialMedia = [
            'facebook' => $setting->facebook,
            'instagram' => $setting->instagram,
            'x' => $setting->x,
            'linkedin' => $setting->linkedin,
            'discord' => $setting->discord,
            'youtube' => $setting->youtube,
            'pinterest' => $setting->pinterest,
            'whatsapp' => $setting->whatsapp,
        ];

        return response()->json([
            'message' => 'تم تحديث روابط التواصل الاجتماعي بنجاح',
            'social_media' => $socialMedia,
        ], 200);
    }
}