<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\PointsTransaction;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use App\Http\Resources\PointsTransactionResource; // Assume a resource for PointsTransaction

class ReferralController extends Controller
{
    public function referralStats($id, Request $request)
    {
        // Find the user
        $user = User::find($id);

        if (!$user) {
            return response()->json([
                'message' => 'المستخدم غير موجود',
            ], 404);
        }

        // Get query
        $date = $request->input('date');
        $actionType = $request->input('action_type'); // product_share or website_share
        $perPage = $request->input('per_page', 10); // Default to 10 items per page

        // Base queries
        $referralsQuery = $user->referralsMade(); // Referrals made by the user
        $pointsQuery = PointsTransaction::where('user_id', $id);

        // Filter by date if provided
        if ($date) {
            $validator = Validator::make(['date' => $date], [
                'date' => 'date_format:m/d/Y'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'message' => 'صيغة التاريخ غير صحيحة، استخدم mm/dd/yyyy',
                ], 400);
            }

            $formattedDate = Carbon::createFromFormat('m/d/Y', $date)->format('Y-m-d');
            $referralsQuery->whereDate('created_at', $formattedDate);
            $pointsQuery->whereDate('created_at', $formattedDate);
        }

        // Filter by action_type if provided
        if ($actionType) {
            $validator = Validator::make(['action_type' => $actionType], [
                'action_type' => 'in:product_share,website_share,referral_signup'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'message' => 'نوع النشاط غير صحيح، استخدم product_share أو website_share أو referral_signup',
                ], 400);
            }

            $pointsQuery->where('action_type', $actionType);
        }

        // Execute queries with pagination
        $pointsTransactions = $pointsQuery->paginate($perPage);

        return response()->json([
            'message' => 'تم استرجاع بيانات التسويق بنجاح',
            // 'user' => [
            //     'id' => $user->id,
            //     'full_name' => $user->full_name,
            //     'email' => $user->email,
            //     'points' => $user->points,
            // ],
            'points_transactions' => PointsTransactionResource::collection($pointsTransactions),
            'pagination' => [
                'current_page' => $pointsTransactions->currentPage(),
                'per_page' => $pointsTransactions->perPage(),
                'total' => $pointsTransactions->total(),
                'last_page' => $pointsTransactions->lastPage(),
                'from' => $pointsTransactions->firstItem(),
                'to' => $pointsTransactions->lastItem(),
            ],
            'referrals_count' => $referralsQuery->count(),
            'product_shares_count' => $pointsQuery->where('action_type', 'product_share')->count(),
            'website_shares_count' => $pointsQuery->where('action_type', 'website_share')->count(),
            'total_points_earned' => $pointsQuery->sum('points'),
        ], 200);
    }
}