<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API\Dashboard;

use App\Models\Country;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\CountryResource;

class CountryController extends Controller
{
    // عرض كل الدول
    public function index()
    {
        return response()->json(CountryResource::collection(Country::all()));
    }

    // إنشاء دولة جديدة
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|array',
            'name.en' => 'required|string',
            'name.ar' => 'required|string',
        ]);

        // Ensure we're passing the array directly
        $country = Country::create([
            'name' => $validated['name'] // already validated as array
        ]);

        return response()->json($country, 201);
    }


    // عرض دولة معينة
    public function show(Country $country)
    {
        return response()->json($country);
    }

    // تعديل دولة
    public function update(Request $request, Country $country)
    {
        $data = $request->validate([
            'name' => 'sometimes|array',
            'name.ar' => 'sometimes|string',
            'name.en' => 'sometimes|string',
        ]);

        $country->update([
            'name' => array_merge($country->name, $data['name'] ?? []),
        ]);

        return response()->json($country);
    }

    // حذف دولة
    public function destroy(Country $country)
    {
        $country->delete();

        return response()->json(['message' => 'Country deleted successfully']);
    }

}