<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API;

use Log;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\CategoryResource;

class CategoryController extends Controller
{
    public function index()
    {
        try {
            $categories = Category::query()->whereNull('parent_id')->with(['categories'])->get();

            return response()->json([
                'message' => 'Data retrieved successfully',
                'data' => CategoryResource::collection($categories),
            ], 200);
        } catch (\Exception $e) {
            // Log the error for debugging
            Log::error('Error retrieving categories: ' . $e->getMessage());

            return response()->json([
                'message' => 'An error occurred while retrieving data',
                'error' => config('app.debug') ? $e->getMessage() : 'Internal server error',
            ], 500);
        }
    }
}