<?php

namespace App\Exports;

use App\Models\User;
use App\Http\Resources\Dashboard\UserResource;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Http\Request;

class UsersExport implements FromCollection, WithHeadings, WithMapping
{
    public function collection()
    {
        return User::all();
    }

    public function map($user): array
    {
        $resource = new UserResource($user);
        $data = $resource->toArray(request());

        return [
            $data['id'] ?? null,
            $data['full_name'] ?? null,
            $data['email'] ?? null,
            $data['phone'] ?? null,
            $data['status'] ?? null,
            $data['created_at'] ?? null,
        ];
    }

    public function headings(): array
    {
        return [
            'ID',
            'Full Name',
            'Email',
            'Phone',
            'Status',
            'Created At',
        ];
    }
}