<?php

use App\Http\Controllers\API\HomeController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\FaqController;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\CartController;
use App\Http\Controllers\API\OrderController;
use App\Http\Controllers\API\ReviewController;
use App\Http\Controllers\API\AddressController;
use App\Http\Controllers\API\SettingController;
use App\Http\Controllers\API\FavouriteController;
use App\Http\Controllers\API\CreditCardController;
use App\Http\Controllers\API\StaticPageController;
use Illuminate\Foundation\Auth\EmailVerificationRequest;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('reviews')->group(function () {
    Route::get('/', [ReviewController::class, 'index']);
    Route::post('/', [ReviewController::class, 'store']);
    Route::get('/{review}', [ReviewController::class, 'show']);
    Route::put('/{review}', [ReviewController::class, 'update']);
    Route::delete('/{review}', [ReviewController::class, 'destroy']);
});


// Routes Auth

// Routes للتسجيل وتسجيل الدخول وإعادة تعيين كلمة المرور
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);

// Routes لتسجيل الدخول الاجتماعي
Route::get('/auth/google', [AuthController::class, 'redirectToGoogle']);
Route::get('/auth/google/callback', [AuthController::class, 'handleGoogleCallback']);

Route::get('/auth/facebook', [AuthController::class, 'redirectToFacebook']);
Route::get('/auth/facebook/callback', [AuthController::class, 'handleFacebookCallback']);

// Route لتفعيل البريد
Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
    $request->fulfill();

    return response()->json(['message' => 'تم تفعيل البريد الإلكتروني بنجاح']);
})->middleware(['signed'])->name('verification.verify');

// Routes محمية بـ Sanctum
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::post('/email/verify', [AuthController::class, 'verifyEmail']);

    // Routes Favourites
    Route::post('/favourites', [FavouriteController::class, 'addFavourite']);
    Route::delete('/favourites', [FavouriteController::class, 'removeFavourite']);
    Route::get('/favourites', [FavouriteController::class, 'getFavourites']);

    // Routes Carts
    Route::prefix('cart')->group(function () {
        Route::post('/', [CartController::class, 'addToCart']);
        Route::delete('/', [CartController::class, 'removeFromCart']);
        Route::get('/', [CartController::class, 'getCart']);
    });

    // Routes Addresses
    Route::prefix('addresses')->group(function () {
        Route::post('/', [AddressController::class, 'addAddress']);
        Route::get('/', [AddressController::class, 'getAddresses']);
        Route::delete('/', [AddressController::class, 'deleteAddress']);
        Route::put('/', [AddressController::class, 'updateAddress']);
    });

    // Routes credit-cards
    Route::prefix('credit-cards')->group(function () {
        Route::get('/', [CreditCardController::class, 'index']);
        Route::post('/', [CreditCardController::class, 'store']);
        //   Route::get('/{id}', [CreditCardController::class, 'show']);
        Route::put('/{id}', [CreditCardController::class, 'update']);
        Route::delete('/{id}', [CreditCardController::class, 'destroy']);
    });

    // Routes order
    Route::post('/orders', [OrderController::class, 'createOrder']);

});


// Routes static-pages
Route::prefix('static-pages')->group(function () {
    //  Route::get('/', [StaticPageController::class, 'index']); // Get all static pages
    Route::get('/{key}', [StaticPageController::class, 'show']);


});

// Routes faqs
Route::prefix('faqs')->group(function () {
    Route::get('/', [FaqController::class, 'index']);
});

// Routes settings
Route::prefix('settings')->group(function () {
    Route::get('/', [SettingController::class, 'index']); // Get all settings
});

// Routes home
Route::get('/home', [HomeController::class, 'index']);

// Routes customer-support
Route::get('/customer-support', [HomeController::class, 'index']);