<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;

class CustomVerifyEmail extends Notification
{
    use Queueable;

    public function __construct()
    {
        //
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('تفعيل بريدك الإلكتروني')
            ->line('يرجى النقر على الزر أدناه لتفعيل بريدك الإلكتروني.')
            ->action('تفعيل البريد', url('/api/verify-email?token=' . urlencode($notifiable->createToken('verify')->plainTextToken)))
            ->line('إذا لم تقم بإنشاء حساب، يمكنك تجاهل هذا البريد.');
    }
}