<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use App\Notifications\ResetPassword as ResetPasswordNotification;
use App\Notifications\CustomVerifyEmail;

class User extends Authenticatable implements MustVerifyEmail
{
	use HasApiTokens, Notifiable;

	protected $table = 'users';

	protected $casts = [
		'email_verified_at' => 'datetime',
		'is_active' => 'bool',
	];

	protected $hidden = [
		'password',
		'remember_token',
	];

	protected $fillable = [
		'full_name',
		'email',
		'email_verified_at',
		'password',
		'is_active',
		'remember_token',
		'google_id',
		'facebook_id',
	];

	public function carts()
	{
		return $this->hasMany(Cart::class);
	}

	public function credit_cards()
	{
		return $this->hasMany(CreditCard::class);
	}

	public function orders()
	{
		return $this->hasMany(Order::class);
	}

	public function reviews()
	{
		return $this->hasMany(Review::class);
	}

	public function addresses()
	{
		return $this->hasMany(Address::class);
	}

	// إرسال إشعار التحقق من البريد الإلكتروني
	public function sendEmailVerificationNotification()
	{
		$this->notify(new CustomVerifyEmail);
	}

	// إرسال إشعار إعادة تعيين كلمة المرور
	public function sendPasswordResetNotification($token)
	{
		$this->notify(new ResetPasswordNotification($token));
	}

	// الدالة التي تُرجع البريد الإلكتروني للتحقق منه
	public function getEmailForVerification()
	{
		return $this->email;
	}

	// الدالة التي تتحقق إذا كان البريد الإلكتروني قد تم التحقق منه أم لا
	public function hasVerifiedEmail()
	{
		return $this->email_verified_at !== null;
	}

	// الدالة التي تُعين البريد الإلكتروني كتم التحقق
	public function markEmailAsVerified()
	{
		$this->email_verified_at = Carbon::now();
		$this->save();
	}
	public function favourites()
	{
		return $this->hasMany(Favourite::class);
	}
	public function cart()
	{
		return $this->hasOne(Cart::class);
	}


}