<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Setting
 * 
 * @property int $id
 * @property Carbon|null $work_start_time
 * @property Carbon|null $work_end_time
 * @property string|null $work_days
 * @property string|null $facebook
 * @property string|null $instagram
 * @property string|null $x
 * @property string|null $linkedin
 * @property string|null $discord
 * @property string|null $copyright
 * @property string|null $logo
 * @property string|null $address
 * @property string|null $phone_number
 * @property string|null $youtube
 * @property string|null $pinterest
 * @property string|null $welcome_message
 * @property string|null $color_top_header
 * @property string|null $color_navbar
 * @property string|null $color_footer
 * @property string|null $whatsapp
 * @property bool $maintenance_mode
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Setting extends Model
{
	protected $table = 'settings';

	protected $casts = [
		'work_start_time' => 'datetime',
		'work_end_time' => 'datetime',
		'maintenance_mode' => 'bool'
	];

	protected $fillable = [
		'work_start_time',
		'work_end_time',
		'work_days',
		'facebook',
		'instagram',
		'x',
		'linkedin',
		'discord',
		'copyright',
		'logo',
		'address',
		'phone_number',
		'youtube',
		'pinterest',
		'welcome_message',
		'color_top_header',
		'color_navbar',
		'color_footer',
		'whatsapp',
		'maintenance_mode'
	];
}
