<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Product
 * 
 * @property int $id
 * @property int|null $category_id
 * @property string $sku
 * @property int|null $status_id
 * @property string $name
 * @property string|null $description
 * @property string|null $image
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Category|null $category
 * @property Status|null $status
 * @property Collection|CartItem[] $cart_items
 * @property Collection|Discount[] $discounts
 * @property Collection|OrderItem[] $order_items
 * @property Collection|Review[] $reviews
 *
 * @package App\Models
 */
class Product extends Model
{
	protected $table = 'products';

	protected $casts = [
		'category_id' => 'int',
		'status_id' => 'int'
	];

	protected $fillable = [
		'category_id',
		'sku',
		'status_id',
		'name',
		'description',
		'image'
	];

	public function category()
	{
		return $this->belongsTo(Category::class);
	}

	public function status()
	{
		return $this->belongsTo(Status::class);
	}

	public function cart_items()
	{
		return $this->hasMany(CartItem::class);
	}

	public function discounts()
	{
		return $this->hasMany(Discount::class);
	}

	// public function order_items()
	// {
	// 	return $this->hasMany(OrderItem::class);
	// }

	public function reviews()
	{
		return $this->hasMany(Review::class);
	}

	public function cartItems()
	{
		return $this->hasMany(CartItem::class);
	}

	public function favourites()
	{
		return $this->hasMany(Favourite::class);
	}

	public function orderItems()
	{
		return $this->hasMany(OrderItem::class);
	}
}