<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Order
 * 
 * @property int $id
 * @property int|null $user_id
 * @property string|null $phone_number
 * @property float|null $total_price
 * @property string|null $shipping_address
 * @property string|null $payment_method
 * @property string|null $tracking_number
 * @property int|null $status_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Status|null $status
 * @property User|null $user
 * @property Collection|OrderItem[] $order_items
 *
 * @package App\Models
 */
class Order extends Model
{
	protected $table = 'orders';

	protected $casts = [
		'user_id' => 'int',
		'total_price' => 'float',
		'status_id' => 'int'
	];

	protected $fillable = [
		'user_id',
		'phone_number',
		'total_price',
		'shipping_address',
		'payment_method',
		'tracking_number',
		'status_id',
		'full_name'
	];

	public function status()
	{
		return $this->belongsTo(Status::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function order_items()
	{
		return $this->hasMany(OrderItem::class);
	}
}