<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Faq
 * 
 * @property int $id
 * @property string $question
 * @property string $answer
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */

class Faq extends Model
{
	protected $fillable = [
		'question',
		'answer',
		'active',
		'sort'
	];

	protected $casts = [
		'question' => 'array',
		'answer' => 'array',
	];

	/**
	 * Get the question based on the current app locale.
	 */
	public function getQuestionAttribute($value)
	{
		$locale = App::getLocale(); // Get the current app locale (en or ar)
		return $value[$locale] ?? $value['en'] ?? null; // Fallback to English if the locale is missing
	}

	/**
	 * Get the answer based on the current app locale.
	 */
	public function getAnswerAttribute($value)
	{
		$locale = App::getLocale(); // Get the current app locale (en or ar)
		return $value[$locale] ?? $value['en'] ?? null; // Fallback to English if the locale is missing
	}
}