<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CreditCard
 * 
 * @property int $id
 * @property int $user_id
 * @property string $card_number_encrypted
 * @property string|null $card_type
 * @property string $cardholder_name
 * @property string $expiry_date
 * @property string $last_four_digits
 * @property string|null $image
 * @property bool $is_default
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User $user
 *
 * @package App\Models
 */
class CreditCard extends Model
{
	protected $table = 'credit_cards';

	protected $casts = [
		'user_id' => 'int',
		'is_default' => 'bool'
	];

	protected $fillable = [
		'user_id',
		'card_number_encrypted',
		'card_type',
		'cardholder_name',
		'expiry_date',
		'last_four_digits',
		'image',
		'is_default'
	];

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
