<?php

/*
    * Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Cart
 * 
 * @property int $id
 * @property int|null $user_id
 * @property string|null $phone_number
 * @property int|null $coupon_code
 * @property float|null $total_price
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User|null $user
 * @property Collection|CartItem[] $cart_items
 *
 * @package App\Models
 */
class Cart extends Model
{
	protected $table = 'cart';

	protected $casts = [
		'user_id' => 'int',
		'coupon_code' => 'int',
		'total_price' => 'float'
	];

	protected $fillable = [
		'user_id',
		'phone_number',
		'coupon_code',
		'total_price'
	];

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function cart_items()
	{
		return $this->hasMany(CartItem::class);
	}
}