<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Address
 * 
 * @property int $id
 * @property string $address_line_1
 * @property string|null $address_line_2
 * @property string $city
 * @property string $country
 * @property string|null $postal_code
 * @property bool $is_default
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Address extends Model
{
	protected $table = 'addresses';

	protected $casts = [
		'is_default' => 'bool'
	];

	protected $fillable = [
		'address_line_1',
		'address_line_2',
		'city',
		'country',
		'postal_code',
		'is_default'
	];
	public function user()
	{
		return $this->belongsTo(User::class);
	}
}