<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StaticPageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = app()->getLocale(); // Get the current app locale (en or ar)

        return [
            'id' => $this->id,
            'key' => $this->key,
            'title' => $locale === 'ar' ? $this->title_ar : $this->title_en,
            'content' => $locale === 'ar' ? $this->content_ar : $this->content_en,
            'image' => $this->image,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}