<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FaqResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = app()->getLocale(); // Get the current app locale (en or ar)

        return [
            'id' => $this->id,
            'question' => $this->question[$locale] ?? $this->question['en'] ?? null,
            'answer' => $this->answer[$locale] ?? $this->answer['en'] ?? null,
            'active' => $this->active,
            'sort' => $this->sort,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}