<?php

/*
    Created by Mohamed.
*/

namespace App\Http\Controllers\API;

use App\Models\Banner;
use App\Models\Slider;
use App\Models\Partner;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Resources\BannerResource;
use App\Http\Resources\SliderResource;
use App\Http\Resources\PartnerResource;
use App\Http\Resources\ProductResource;

class HomeController extends Controller
{
    /**
     * عرض المنتجات مع فلاتر الترتيب والبحث
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        try {
            // بناء استعلام المنتجات
            $productsQuery = Product::where('status_id', 1);

            // فلتر البحث بناءً على اسم المنتج
            if ($request->has('search') && !empty($request->query('search'))) {
                $productsQuery->where('name', 'like', '%' . $request->query('search') . '%');
            }

            // فلتر الترتيب
            if ($request->has('sort')) {
                switch ($request->query('sort')) {
                    case 'high_price':
                        $productsQuery->orderBy('price', 'desc');
                        break;
                    case 'low_price':
                        $productsQuery->orderBy('price', 'asc');
                        break;
                    case 'recent':
                        $productsQuery->orderBy('created_at', 'desc');
                        break;
                    default:
                        // ترتيب افتراضي (مثلًا حسب created_at)
                        $productsQuery->orderBy('created_at', 'desc');
                        break;
                }
            } else {
                // ترتيب افتراضي إذا لم يُحدد
                $productsQuery->orderBy('created_at', 'desc');
            }

            // جلب أول 15 منتج
            $products = $productsQuery->take(15)->get();

            // جلب البيانات الأخرى
            $sliders = Slider::where('is_active', 1)->get();
            $partners = Partner::all();
            $banners = Banner::where('status', 'active')->get();

            return response()->json([
                'message' => 'تم جلب البيانات بنجاح',
                'products' => ProductResource::collection($products),
                'sliders' => SliderResource::collection($sliders),
                'partners' => PartnerResource::collection($partners),
                'banners' => BannerResource::collection($banners),
            ], 200); // 200 بدل 201 لأننا نجلب بيانات وليس ننشئ
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'حدث خطأ',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}