<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Address;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AddressController extends Controller
{
    /**
     * إضافة عنوان جديد
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function addAddress(Request $request)
    {
        // التحقق من البيانات المدخلة
        $validated = $request->validate([
            'address_line_1' => 'required|string|max:255',
            'address_line_2' => 'nullable|string|max:255',
            'city' => 'required|string|max:100',
            'country' => 'required|string|max:100',
            'postal_code' => 'nullable|string|max:20',
            'is_default' => 'boolean',
        ]);

        /** @var \App\Models\User|\Laravel\Sanctum\HasApiTokens $user */
        $user = $request->user();

        if (!$user) {
            return response()->json(['message' => 'غير مصرح'], 401);
        }

        // إذا كان العنوان افتراضيًا، إلغاء افتراضية العناوين الأخرى
        if ($validated['is_default'] ?? false) {
            $user->addresses()->update(['is_default' => false]);
        }

        // إنشاء العنوان
        $address = $user->addresses()->create([
            'user_id' => $user->id,
            'address_line_1' => $validated['address_line_1'],
            'address_line_2' => $validated['address_line_2'],
            'city' => $validated['city'],
            'country' => $validated['country'],
            'postal_code' => $validated['postal_code'],
            'is_default' => $validated['is_default'] ?? false,
        ]);

        return response()->json([
            'message' => 'تم إضافة العنوان بنجاح',
            'address' => $address,
        ], 201);
    }

    /**
     * جلب جميع العناوين
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAddresses(Request $request)
    {
        /** @var \App\Models\User|\Laravel\Sanctum\HasApiTokens $user */
        $user = $request->user();

        if (!$user) {
            return response()->json(['message' => 'غير مصرح'], 401);
        }

        $addresses = $user->addresses()->get();

        return response()->json([
            'message' => 'تم جلب العناوين بنجاح',
            'addresses' => $addresses,
        ]);
    }

    /**
     * حذف عنوان
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteAddress(Request $request)
    {
        // التحقق من البيانات المدخلة
        $validated = $request->validate([
            'address_id' => 'required|exists:addresses,id',
        ]);

        /** @var \App\Models\User|\Laravel\Sanctum\HasApiTokens $user */
        $user = $request->user();

        if (!$user) {
            return response()->json(['message' => 'غير مصرح'], 401);
        }

        // البحث عن العنوان
        $address = $user->addresses()->where('id', $validated['address_id'])->first();

        if (!$address) {
            return response()->json(['message' => 'العنوان غير موجود أو لا ينتمي لك'], 404);
        }

        $address->delete();

        return response()->json(['message' => 'تم حذف العنوان بنجاح']);
    }

    /**
     * تحديث عنوان
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateAddress(Request $request)
    {
        // التحقق من البيانات المدخلة
        $validated = $request->validate([
            'address_id' => 'required|exists:addresses,id',
            'address_line_1' => 'required|string|max:255',
            'address_line_2' => 'nullable|string|max:255',
            'city' => 'required|string|max:100',
            'country' => 'required|string|max:100',
            'postal_code' => 'nullable|string|max:20',
            'is_default' => 'boolean',
        ]);

        /** @var \App\Models\User|\Laravel\Sanctum\HasApiTokens $user */
        $user = $request->user();

        if (!$user) {
            return response()->json(['message' => 'غير مصرح'], 401);
        }

        // البحث عن العنوان
        $address = $user->addresses()->where('id', $validated['address_id'])->first();

        if (!$address) {
            return response()->json(['message' => 'العنوان غير موجود أو لا ينتمي لك'], 404);
        }

        // إذا كان العنوان افتراضيًا، إلغاء افتراضية العناوين الأخرى
        if ($validated['is_default'] ?? false) {
            $user->addresses()->update(['is_default' => false]);
        }

        // تحديث العنوان
        $address->update([
            'address_line_1' => $validated['address_line_1'],
            'address_line_2' => $validated['address_line_2'],
            'city' => $validated['city'],
            'country' => $validated['country'],
            'postal_code' => $validated['postal_code'],
            'is_default' => $validated['is_default'] ?? false,
        ]);

        return response()->json([
            'message' => 'تم تحديث العنوان بنجاح',
            'address' => $address,
        ]);
    }
}